/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.planning.algorithms.SameGorTransactionFilter;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.MaterialQuotas;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeVisitorAdapter;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MaterialBoundUpdater
extends Processor {
    private StoreSchedule.MatHorizonTreatment matHorizonTreatment = StoreSchedule.MatHorizonTreatment.MATERIAL_SPECIFIC;
    private long materialHorizonBase;
    private SetMultimap<Material, Operation> matOps;
    private SetMultimap<Operation, Material> opMats;
    private Set<Operation> plannableOps;
    private Set<Operation> plannableOpsView;
    private long lastMinTime;
    private Set<Material> affectedMats;

    public void setMatHorizonTreatment(StoreSchedule.MatHorizonTreatment matHorizonTreatment) {
        this.matHorizonTreatment = matHorizonTreatment;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        this.matOps = HashMultimap.create();
        this.opMats = HashMultimap.create();
        DefaultChangeTrackingSet<Operation> plannableOps = DefaultChangeTrackingSet.create();
        this.plannableOps = plannableOps;
        this.plannableOpsView = UnmodifiableChangeTrackingSet.create(plannableOps);
        Superplan superplan = this.getScheduler().getSuperplan();
        long fixationDate = superplan.getFixationDate();
        this.materialHorizonBase = GeneralizedRequest.isDateValid(fixationDate) ? fixationDate : superplan.getPlan().getTimeBounds().getStart();
        this.lastMinTime = Long.MIN_VALUE;
        this.affectedMats = Sets.newHashSet();
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (ops instanceof ChangeTrackingSet) {
            ChangeTrackingSet chtrSet = (ChangeTrackingSet)ops;
            ChangeTrackingSet.Changes changes = chtrSet.getChanges();
            this.removeOps(changes.getRemoved());
            Set<Operation> added = changes.getAdded();
            this.catalogizeOps(added);
            this.updateCached(this.affectedMats);
            this.updateNew(added);
            this.plannableOps.addAll(added);
        } else {
            this.plannableOps.clear();
            this.matOps.clear();
            this.opMats.clear();
            this.catalogizeOps(ops);
            this.updateNew(ops);
            this.matOps.clear();
            this.opMats.clear();
            this.plannableOps.addAll(ops);
        }
        return Tuple.create(this.getDefaultSuccessor(), this.plannableOpsView);
    }

    private void catalogizeOps(Set<Operation> ops) {
        for (Operation op : ops) {
            Action action = op.getAction();
            List<MaterialQuantity> ingredients = action.getBom().ingredients();
            if (ingredients == null || ingredients.isEmpty()) continue;
            for (MaterialQuantity ingredient : ingredients) {
                Material material = ingredient.getMaterial();
                this.matOps.put(material, op);
                this.opMats.put(op, material);
            }
        }
    }

    private void updateNew(Set<Operation> ops) {
        for (Operation op : ops) {
            this.setBounds(op, (Set<Material>)this.opMats.get((Object)op));
        }
    }

    private void updateCached(Set<Material> mats) {
        HashSet<Operation> ops = Sets.newHashSet();
        for (Material mat : mats) {
            ops.addAll(this.matOps.get((Object)mat));
        }
        for (Operation op : ops) {
            this.setBounds(op, Sets.intersection(this.opMats.get((Object)op), mats));
        }
    }

    private void removeOps(Set<Operation> ops) {
        this.plannableOps.removeAll(ops);
        for (Operation op : ops) {
            for (Material mat : this.opMats.get((Object)op)) {
                this.matOps.remove(mat, op);
            }
            this.opMats.removeAll(op);
        }
    }

    @Override
    public void onOperationPlanned(Operation op) {
        super.onOperationPlanned(op);
        Action action = op.getAction();
        ArrayList<MaterialQuantity> allMatQuants = Lists.newArrayList();
        allMatQuants.addAll(action.getBom().ingredients());
        allMatQuants.addAll(action.getProduces());
        this.affectedMats.clear();
        for (MaterialQuantity mq : allMatQuants) {
            if (!mq.getMaterial().isConsumed()) continue;
            this.affectedMats.add(mq.getMaterial());
        }
        this.lastMinTime = op.getBound().getTime();
    }

    private void setBounds(Operation op, Set<Material> mats) {
        GeneralizedActionRequest gar = op.getGar();
        Plan plan = this.getScheduler().getSuperplan().getPlan();
        StoreSchedule storeSchedule = plan.getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        long minTimeOffset = MaterialBoundUpdater.getMinTimeBeforeOffset(op);
        long qTime = Math.min(this.lastMinTime, this.lastMinTime - minTimeOffset);
        MaterialQuotas quotas = storeSchedule.getInitialForwardQuotas(mats, qTime, this.materialHorizonBase, this.matHorizonTreatment, new SameGorTransactionFilter(gar));
        for (Material mat : mats) {
            if (!mat.isConsumed()) continue;
            double qty = this.getQtyToPlan(op, gar, mat);
            Long newBound = quotas.getMaterialAvailableTime(mat, qty);
            newBound = newBound == null ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(Math.max(newBound, newBound + minTimeOffset));
            op.updateSimpleBound(mat, newBound);
        }
    }

    private double getQtyToPlan(Operation op, GeneralizedActionRequest gar, Material mat) {
        double inPlanQtyMat;
        double v = gar.getRequestedQty() - gar.getOutOfPlanMat();
        if (gar.getInPlanQty() > 0.0) {
            InPlanMatQtyComputer inPlanMatQtyComputer = new InPlanMatQtyComputer(mat);
            gar.accept(inPlanMatQtyComputer, false);
            inPlanQtyMat = inPlanMatQtyComputer.getInPlanQty();
        } else {
            inPlanQtyMat = 0.0;
        }
        double bomFactor = op.getAction().getBom().getQty(mat);
        double qty = (mat.isConstant() ? 1.0 : v) * bomFactor - inPlanQtyMat;
        if (qty < 0.0) {
            qty = 0.0;
        }
        return qty;
    }

    private static long getMinTimeBeforeOffset(Operation op) {
        return op.isActiongramStart() ? op.getAction().getMinTimeToPrepare() : 0L;
    }

    private static class InPlanMatQtyComputer
    extends ProductionTreeVisitorAdapter {
        private final Material material;
        private double inPlanQty;

        InPlanMatQtyComputer(Material material) {
            this.material = material;
        }

        @Override
        public void visit(GeneralizedActionRequest gar) {
            this.visitSao(gar);
        }

        @Override
        public void visit(ActionActivity aa) {
            this.visitSao(aa);
        }

        private void visitSao(StoreActivityOwner sao) {
            for (InPlanStoreActivity inPlanStoreActivity : sao.getStoreActivities()) {
                if (!(inPlanStoreActivity.getQty() < 0.0) || inPlanStoreActivity.getStoreType() != StoreType.INPLAN_ACTUAL || inPlanStoreActivity.getMaterial() != this.material) continue;
                this.inPlanQty += inPlanStoreActivity.getAbsQty();
            }
        }

        public double getInPlanQty() {
            return this.inPlanQty;
        }
    }
}

